% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtreat.R
\name{novel_value_summary}
\alias{novel_value_summary}
\title{Report new/novel appearances of character values.}
\usage{
novel_value_summary(dframe, trackedValues)
}
\arguments{
\item{dframe}{Data frame to inspect.}

\item{trackedValues}{optional named list mapping variables to know values, allows warnings upon novel level appearances (see \code{\link{track_values}})}
}
\value{
frame of novel occurrences
}
\description{
Report new/novel appearances of character values.
}
\examples{

set.seed(23525)
zip <- c(NA, paste('z', 1:10, sep = "_"))
N <- 10
d <- data.frame(zip = sample(zip, N, replace=TRUE),
                zip2 = sample(zip, N, replace=TRUE),
                y = runif(N))
dSample <- d[1:5, , drop = FALSE]
trackedValues <- track_values(dSample, c("zip", "zip2"))
novel_value_summary(d, trackedValues)

}
\seealso{
\code{\link{prepare}}, \code{\link{track_values}}
}
