% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/garcon.R
\name{garcon}
\alias{garcon}
\alias{use_garcon}
\alias{Garcon}
\title{Garcon}
\usage{
use_garcon()
}
\description{
Create a garcon to aniamte images on the waiter.
}
\examples{

## ------------------------------------------------
## Method `Garcon$new`
## ------------------------------------------------

\dontrun{Garcon$new("img")$set(30)}

## ------------------------------------------------
## Method `Garcon$set`
## ------------------------------------------------

\dontrun{Garcon$new("img")$set(30)}

## ------------------------------------------------
## Method `Garcon$inc`
## ------------------------------------------------

\dontrun{Garcon$new("img")$inc(30)}

## ------------------------------------------------
## Method `Garcon$reset`
## ------------------------------------------------

\dontrun{Garcon$new("img")$set(30)$reset()}

## ------------------------------------------------
## Method `Garcon$destroy`
## ------------------------------------------------

\dontrun{Garcon$new("img")$set(30)$destroy()}

## ------------------------------------------------
## Method `Garcon$stop`
## ------------------------------------------------

\dontrun{Garcon$new("img")$set(30)$stop()}

## ------------------------------------------------
## Method `Garcon$close`
## ------------------------------------------------

\dontrun{Garcon$new("img")$set(30)$close()}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Garcon$new()}}
\item \href{#method-set}{\code{Garcon$set()}}
\item \href{#method-inc}{\code{Garcon$inc()}}
\item \href{#method-reset}{\code{Garcon$reset()}}
\item \href{#method-destroy}{\code{Garcon$destroy()}}
\item \href{#method-print}{\code{Garcon$print()}}
\item \href{#method-stop}{\code{Garcon$stop()}}
\item \href{#method-close}{\code{Garcon$close()}}
\item \href{#method-clone}{\code{Garcon$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$new(
  image,
  bg_color = "#FFFFFF",
  opacity = 0.5,
  direction = c("bt", "tb", "lr", "rl"),
  filter = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image}}{The CSS id of the image tag.}

\item{\code{bg_color}}{Background overlay color in hexadecimal or RGB.}

\item{\code{opacity}}{Overlay transparency.}

\item{\code{direction}}{Animation direction. Possible values: `lr` (left to right), 
`rl` (right to left), `bt` (bottom to top), `tb` (top to bottom).}

\item{\code{filter}}{Filter to apply, options are `blur`, `grayscale`, `sepia`, 
`hue-rotate`, `invert`, `opacity`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise the garçon.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$set(30)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set"></a>}}
\subsection{Method \code{set()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$set(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Percentage to set to.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Value to set the garçon to.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$set(30)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-inc"></a>}}
\subsection{Method \code{inc()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$inc(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Percentage to increase to.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Value to increase the garçon to.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$inc(30)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\subsection{Method \code{reset()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$reset(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Percentage to set to.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Reset the garçon to.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$set(30)$reset()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-destroy"></a>}}
\subsection{Method \code{destroy()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$destroy()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Kill the garçon to.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$set(30)$destroy()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
print the garcon
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stop"></a>}}
\subsection{Method \code{stop()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$stop()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Stop the garçon.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$set(30)$stop()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-close"></a>}}
\subsection{Method \code{close()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$close()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Close the garçon.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Garcon$new("img")$set(30)$close()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Garcon$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
