% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varname.R
\name{varname}
\alias{varname}
\title{Add Internal Name to Vector}
\usage{
varname(x, name)
}
\arguments{
\item{x}{A vector to add a \code{varname} attribute (i.e.,
\code{attributes(x)[["varname"]]})}

\item{name}{A name to assign to \code{attributes(x)[["varname"]]}.}
}
\value{
Returns a vector of the class \code{variable} with a
\code{attributes(x)[["varname"]]} assigned.
}
\description{
Adds the class \code{variable} and an internal
\code{attributes(x)[["varname"]]} attribute to a vector.
}
\examples{
varname(1:10, "A")
attributes(varname(1:10, "A"))
sum(varname(1:10, "A"))

varname(LETTERS, "Caps")
attributes(varname(LETTERS, "Caps"))
paste(varname(LETTERS, "Caps"), collapse="")
}
