% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_accelerometry_counts_into_bouts.R
\name{identify_bouts}
\alias{identify_bouts}
\title{Identify Bouts:}
\usage{
identify_bouts(
  accelerometry_counts,
  maximum_number_consec_inactive_epochs_in_bout,
  active_counts_per_epoch_min,
  minimum_bout_length
)
}
\arguments{
\item{accelerometry_counts}{A data frame containing accelerometry counts and times}

\item{maximum_number_consec_inactive_epochs_in_bout}{Maximum number of consecutive inactive epochs in a bout without ending the bout}

\item{active_counts_per_epoch_min}{Minimum accelerometer counts for an epoch to be considered active (vs. inactive)}

\item{minimum_bout_length}{Minimum number of epochs for a period of activity to be considered as a potential bout}
}
\value{
A data frame with the same columns as the input data frame \code{accelerometry_counts},
but with a new column named \code{bout} that indicates whether each epoch is part of a bout
(in which case it gets a bout number assigned) or not (0)
}
\description{
Identify Bouts:
}
\details{
This function partitions the accelerometry data into bouts of activity and non-bouts by
first identifying all epochs that are definitely not part of bouts. Then, it uses run length encoding to
partition the data into potential bouts and non-bouts, and labels each potential bout as a bout or non-bout
based on whether it meets the criteria for bout length and the number of consecutive inactive epochs allowed.
Finally, the function adds a new column to the input data frame \code{accelerometry_counts} named \code{bout}
that indicates whether each epoch is part of a bout (1) or not (0).
}
