% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R
\name{washi_flextable}
\alias{washi_flextable}
\title{WaSHI flextable style}
\usage{
washi_flextable(
  data,
  cols_bold = NULL,
  header_font_color = "white",
  header_bg_color = washi_pal[["standard"]][["green"]],
  border_color = washi_pal[["standard"]][["tan"]]
)
}
\arguments{
\item{data}{Dataframe for the table.}

\item{cols_bold}{Numeric indices of columns to bold. Defaults to
\code{NULL}.}

\item{header_font_color}{Hexcode color for header font. Defaults to
white.}

\item{header_bg_color}{Hexcode color for header background.
Defaults to WaSHI green.}

\item{border_color}{Hexcode color for horizontal borders. Defaults
to WaSHI tan.}
}
\value{
A flextable formatted in WaSHI's style.
}
\description{
Creates a flextable in WaSHI's style.
}
\examples{
subset(example_data_wide, select = c(
  "sampleId", "county", "crop", "totalN_\%", "totalC_\%"
)) |>
  washi_flextable(cols_bold = 1)
}
\concept{table functions}
