% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{wb_search}
\alias{wb_search}
\title{Search indicator information available through the World Bank API}
\usage{
wb_search(
  pattern,
  fields = c("indicator_id", "indicator", "indicator_desc"),
  extra = FALSE,
  cache,
  ignore.case = TRUE,
  ...
)
}
\arguments{
\item{pattern}{Character string or regular expression to be matched}

\item{fields}{Character vector of column names through which to search}

\item{extra}{if FALSE, only the indicator ID and short name are returned,
if \code{TRUE}, all columns of the \code{cache} parameter's indicators data frame
are returned. Default is \code{FALSE}}

\item{cache}{List of data frames returned from \code{\link[=wb_cache]{wb_cache()}}. If omitted,
\link{wb_cachelist} is used}

\item{ignore.case}{if \code{FALSE}, the pattern matching is case sensitive and
if \code{TRUE}, case is ignored during matching. Default is \code{TRUE}}

\item{...}{Any additional \code{\link[=grep]{grep()}} agruments you which to pass}
}
\value{
a \link[tibble:tibble-package]{tibble} with indicators that match the search pattern.
}
\description{
This function allows finds indicators that match a search term and returns
a data frame of matching results
}
\examples{
\donttest{d <- wb_search(pattern = "education")}

\donttest{d <- wb_search(pattern = "Food and Agriculture Organization", fields = "source_org")}

# with regular expression operators
# 'poverty' OR 'unemployment' OR 'employment'
\donttest{d <- wb_search(pattern = "poverty|unemployment|employment")}

# pass any other grep argument along as well
# everything without 'education'
\donttest{d <- wb_search(pattern = "education", invert = TRUE)}

# contains "gdp" AND "trade"
\donttest{d <- wb_search("^(?=.*gdp)(?=.*trade).*", perl = TRUE)}

# contains "gdp" and NOT "trade"
\donttest{d <- wb_search("^(?=.*gdp)(?!.*trade).*", perl = TRUE)}
}
