% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panet_control.R
\name{rpactl.preference}
\alias{rpactl.preference}
\title{Set parameters for source and target preference function}
\usage{
rpactl.preference(
  sparams = c(1, 1, 0, 0, 1),
  tparams = c(0, 0, 1, 1, 1),
  params = c(1, 1)
)
}
\arguments{
\item{sparams}{Parameters of the source preference function for directed
networks. Probability of choosing an existing node as the source node is
proportional to \code{sparams[1] * out-strength^sparams[2] + sparams[3] *
in-strength^sparams[4] + sparams[5]}.}

\item{tparams}{Parameters of the target preference function for directed
networks. Probability of choosing an existing node as the source node is
proportional to \code{tparams[1] * out-strength^tparams[2] + tparams[3] *
in-strength^tparams[4] + tparams[5]}.}

\item{params}{Parameters of the preference function for undirected networks.
Probability of choosing an existing node is proportional to
\code{strength^param[1] + param[2]}.}
}
\value{
A list of class \code{rpactl} with components \code{sparams},
  \code{tparams}, and \code{params} with meanings as explained under 
  'Arguments'.
}
\description{
Set parameters for source and target preference function
}
\examples{
control <- rpactl.preference(sparams = c(1, 2, 0, 0, 0.1),
    tparams = c(0, 0, 1, 2, 0.1))
}
