% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moisture_conversions.R
\name{dewpoint.to.humidity}
\alias{dewpoint.to.humidity}
\title{Calculate relative humidity.}
\usage{
dewpoint.to.humidity(dp = NA, t = NA, temperature.metric = "fahrenheit")
}
\arguments{
\item{dp}{Numeric vector of dew point temperatures.}

\item{t}{Numeric vector of air temperatures.}

\item{temperature.metric}{Character string indicating the temperature
metric of air temperature and dew point temperature. Possible values
are \code{fahrenheit} or \code{celsius}.}
}
\value{
A numeric vector of relative humidity (in \%)
}
\description{
\code{dewpoint.to.humidity} creates a numeric vector of relative humidity
  from numerical vectors of air temperature and dew point temperature.
}
\details{
Dew point temperature and temperature must be in the same
   metric (i.e., either both in Celsius or both in Fahrenheit). If
   necessary, use \code{\link{fahrenheit.to.celsius}} or
   \code{\link{celsius.to.fahrenheit}} to convert before using this
   function.
}
\note{
Equations are from the source code for the US National Weather
    Service's
    \href{http://www.wpc.ncep.noaa.gov/html/heatindex.shtml}{online heat index calculator}.
}
\examples{
# Calculate relative humidity from air temperature and
# dew point temperature.

data(lyon)
lyon$RH <- dewpoint.to.humidity(t = lyon$TemperatureC,
                                dp = lyon$DewpointC,
                                temperature.metric = 'celsius')
lyon

}
\author{
Brooke Anderson \email{brooke.anderson@colostate.edu},
Roger Peng \email{rdpeng@gmail.com}
}
\references{
National Weather Service Hydrometeorological Prediction
   Center Web Team. Heat Index Calculator. 30 Jan 2015.
   \url{http://www.wpc.ncep.noaa.gov/html/heatindex.shtml}.
   Accessed 18 Dec 2015.
}
\seealso{
\code{\link{humidity.to.dewpoint},
   \link{fahrenheit.to.celsius},
   \link{celsius.to.fahrenheit}}
}

