% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/chemspider.R
\name{csid_compinfo}
\alias{csid_compinfo}
\title{Get record details (CSID, StdInChIKey, StdInChI, SMILES) by ChemSpider ID}
\usage{
csid_compinfo(csid, token, verbose = TRUE, ...)
}
\arguments{
\item{csid}{character, ChemSpider ID.}

\item{token}{character; security token.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a list of four, with entries: CSID (ChemSpider ID), InChI, InChIKey and SMILES string.
}
\description{
Get record details from ChemspiderId (CSID), see \url{http://www.chemspider.com/}
}
\note{
A security token is neeeded. Please register at RSC
\url{https://www.rsc.org/rsc-id/register}
for a security token.
}
\examples{
\dontrun{
# Fails because no TOKEN is included
token <- '<YOUR-SECURITY-TOKEN>'
# convert CAS to CSID
csid <- get_csid("Triclosan", token = token)
csid_compinfo(csid, token)
# multiple inpits
csids <- get_csid("3380-34-5", token = token)
# fails:
# csid_compinfo(csids, token = token)
lapply(csids, csid_compinfo, token = token)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\seealso{
\code{\link{get_csid}} to retrieve ChemSpider IDs,
\code{\link{csid_extcompinfo}} for extended compound information.
}

