% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubchem.R
\name{pc_synonyms}
\alias{pc_synonyms}
\title{Search synonyms in pubchem}
\usage{
pc_synonyms(
  query,
  from = c("name", "cid", "sid", "aid", "smiles", "inchi", "inchikey"),
  match = c("all", "first", "ask", "na"),
  verbose = getOption("verbose"),
  arg = NULL,
  choices = NULL,
  ...
)
}
\arguments{
\item{query}{character; search term.}

\item{from}{character; type of input, can be one of "name" (default), "cid",
"sid", "aid", "smiles", "inchi", "inchikey"}

\item{match}{character; How should multiple hits be handled? \code{"all"}
returns all matches, \code{"first"} returns only the first result,
\code{"ask"} enters an interactive mode and the user is asked for input,
\code{"na"} returns \code{NA} if multiple hits are found.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{arg}{character; optional arguments like "name_type=word" to match
individual words.}

\item{choices}{deprecated.  Use the \code{match} argument instead.}

\item{...}{currently unused}
}
\value{
a named list.
}
\description{
Search synonyms using PUG-REST,
see \url{https://pubchem.ncbi.nlm.nih.gov/}.
}
\note{
Please respect the Terms and Conditions of the National Library of
Medicine, \url{https://www.nlm.nih.gov/databases/download.html} the data
usage policies of National Center for Biotechnology Information,
\url{https://www.ncbi.nlm.nih.gov/home/about/policies/},
\url{https://pubchemdocs.ncbi.nlm.nih.gov/programmatic-access}, and the data
usage policies of the indicidual data sources
\url{https://pubchem.ncbi.nlm.nih.gov/sources/}.
}
\examples{
\donttest{
pc_synonyms("Aspirin")
pc_synonyms(c("Aspirin", "Triclosan"))
pc_synonyms(5564, from = "cid")
pc_synonyms(c("Aspirin", "Triclosan"), match = "ask")
}
}
\references{
Wang, Y., J. Xiao, T. O. Suzek, et al. 2009 PubChem: A Public
Information System for
Analyzing Bioactivities of Small Molecules. Nucleic Acids Research 37:
623–633.

Kim, Sunghwan, Paul A. Thiessen, Evan E. Bolton, et al. 2016
PubChem Substance and Compound Databases. Nucleic Acids Research 44(D1):
D1202–D1213.

Kim, S., Thiessen, P. A., Bolton, E. E., & Bryant, S. H. (2015).
PUG-SOAP and PUG-REST: web services for programmatic access to chemical
information in PubChem. Nucleic acids research, gkv396.
}
