% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percent_located_disasters.R
\name{percent_located_disasters}
\alias{percent_located_disasters}
\title{Percent of Disasters Successfully Geocoded}
\usage{
percent_located_disasters(
  .,
  how = "any",
  lat_column = "lat",
  lng_column = "lng",
  plot_result = TRUE
)
}
\arguments{
\item{.}{Data Frame that has been locationized. see \code{weed::split_locations}}

\item{how}{takes in a function, "any", or "all" to determine how to count the disaster as being geocoded
if any, at least one location must be coded, if all, all locations must have lat/lng
if a function, it must take in a logical vector and return a single logical}

\item{lat_column}{Name of column containing Latitude data}

\item{lng_column}{Name of column containing Longitude data}

\item{plot_result}{Determines output type (Plot or Summarized Data Frame)}
}
\value{
The percent and number of Locations that have been geocoded (see \code{plot_result} for type of output)
}
\description{
Tells us how successful the geocoding is.

How many of the disasters in this data frame have non NA coordinates?
}
\examples{
d <- tibble::tribble(
~`Dis No`, ~value,  ~location_word,                    ~Country,     ~lat,       ~lng,
1, "city of new york",      "new york",                       "USA", 40.71427,  -74.00597,
2, "kerala, chennai municipality, and san francisco",  "kerala", "India", 10.41667,       76.5,
2, "kerala, chennai municipality, and san francisco",  "chennai",  "India", 13.08784,   80.27847)
percent_located_disasters(d,
how = "any",
lat_column = "lat",
lng_column = "lng",
plot_result = FALSE)

}
