% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_estimators.R
\name{johnson_method}
\alias{johnson_method}
\title{Estimation of Failure Probabilities using Johnson's Method}
\usage{
johnson_method(x, event, id = rep("XXXXXX", length(x)))
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{id}{a character vector for the identification of every unit.}
}
\value{
A data frame containing id, lifetime characteristic, status of the
  unit, the adjusted rank and the estimated failure probability. For right
  censored observations the cells of the rank and probabilty columns are
  filled with NA values.
}
\description{
This non-parametric approach is used to estimate the failure probabilities in
terms of (multiple) right censored data. Compared to complete data the
correction is done by calculating adjusted ranks which takes non-defective
units into account.
}
\examples{
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)
uic   <- c("3435", "1203", "958X", "XX71", "abcd", "tz46",
           "fl29", "AX23", "Uy12", "kl1a")

df_john <- johnson_method(x = obs, event = state, id = uic)
}
