% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_analysis_filters.R
\name{wbt_bilateral_filter}
\alias{wbt_bilateral_filter}
\title{Bilateral filter}
\usage{
wbt_bilateral_filter(
  input,
  output,
  sigma_dist = 0.75,
  sigma_int = 1,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input raster file path. See \code{wbt_file_path()} for details.}

\item{output}{Output raster file.}

\item{sigma_dist}{Standard deviation in distance in pixels.}

\item{sigma_int}{Standard deviation in intensity in pixels.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
A bilateral filter is an edge-preserving smoothing filter introduced by Tomasi and Manduchi (1998).
}
\keyword{ImageProcessingToolsFilters}
