% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math_stat_analysis.R
\name{wbt_conditioned_latin_hypercube}
\alias{wbt_conditioned_latin_hypercube}
\title{Conditioned latin hypercube}
\usage{
wbt_conditioned_latin_hypercube(
  inputs,
  output,
  samples = 500,
  iterations = 25000,
  seed = NULL,
  prob = 0.5,
  threshold = NULL,
  temp = 1,
  temp_decay = 0.05,
  cycle = 10,
  average = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{inputs}{Name of the input raster file.}

\item{output}{Output shapefile.}

\item{samples}{Number of sample sites returned.}

\item{iterations}{Maximum iterations (if stopping criteria not reached).}

\item{seed}{Seed for RNG consistency.}

\item{prob}{Probability of random resample or resampling worst strata between \verb{[0,1]}.}

\item{threshold}{Objective function values below the theshold stop the resampling iterations.}

\item{temp}{Initial annealing temperature between \verb{[0,1]}.}

\item{temp_decay}{Annealing temperature decay proportion between \verb{[0,1]}. Reduce temperature by this proportion each annealing cycle.}

\item{cycle}{Number of iterations before decaying annealing temperature.}

\item{average}{Weight the continuous objective funtion by the 1/N contributing strata.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Implements conditioned Latin Hypercube sampling.
}
\keyword{MathandStatsTools}
