% Generated by roxygen2 (4.0.1): do not edit by hand
\name{Cr}
\alias{Cr}
\title{Movement Correlation Coefficient}
\usage{
Cr(traj1, traj2, tc = 0)
}
\arguments{
\item{traj1}{an object of the class \code{ltraj} which contains the time-stamped
movement fixes of the first object. Note this object must be a \code{type II
ltraj} object. For more information on objects of this type see \code{
help(ltraj)}.}

\item{traj2}{same as \code{traj1}.}

\item{tc}{time threshold for determining simultaneous fixes -- see function: \code{GetSimultaneous}.}
}
\value{
This function returns the Shirabe (2006) correlation statistic for two moving objects.
}
\description{
The function \code{Cr} computes the correlation statistic for movement data as presented
  in the paper by Shirabe (2006). The statistic is essentially a Pearson product-moment
  correlation statistic formulated for use with movement data.
}
\details{
The function \code{Cr} can be used to measure the level of dynamic interaction (termed correlation)
  between a pair of simultaneously moving objects. The statistic is sensitive to
  interaction in both movement direction (azimuth) and displacement, but is unable to
  disentangle the effects of these components.
}
\examples{
data(deer)
deer37 <- deer[1]
deer38 <- deer[2]
#tc = 7.5 minutes
Cr(deer37, deer38, tc = 7.5*60)
}
\references{
Shirabe, T. 2006. Correlation analysis of discrete motions. In: Raubal, M.,
Miller, HJ, Frank, AU, and Goodchild, M. eds. GIScience 2006, LNCS 4197. Berlin: Springer-Verlag;
370-382.
}
\seealso{
GetSimultaneous, DI
}
\keyword{indices}

