% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triangleProb.R
\name{triangleProb}
\alias{triangleProb}
\title{Calculate probabilities from a triangle distribution based on Hull and
  Muir (2010) maximum distance as proposed by Huso and Dalthorp (2014).}
\usage{
triangleProb(hubHeight, bladeRadius, lowerBound = 0, upperBound = Inf, ...)
}
\arguments{
\item{hubHeight}{Numeric, turbine hub height.}

\item{bladeRadius}{Numeric, turbine blade radius.}

\item{lowerBound}{Numeric, default is zero, see Details.}

\item{upperBound}{Numeric, default is \code{Inf}, see Details.}

\item{...}{Currently ignored.}
}
\value{
List of two data frames: the first has distances in one-unit increments
  (the outer distance), the probabilities between the distances, and a column
  indicating size class; the second gives the maximum distance of each size class.
}
\description{
Calculate the probabilities between one-unit increments of a right
  triangle distribution.
}
\details{
A right triangle is constructed with the 90 degree corner at the
  origin in the first quadrant of the cartesian plane. The \code{lowerBound}
  will move the left edge of the triangle to the right. The \code{upperBound} will truncate the
 triangle distribution at that value.

The maximum horizontal distance is calculated using
\code{\link{hullMuirMaxDistance}}. This is typically not a
  whole number and the \code{\link{ceiling}} is used. The maximum
  vertical distance is such that the area under the hypotenuse edge of triangle
  integrates to one. This is done using the equation for the area of a triangle.

  The two points that make up the hypotenuse are used to calculate the slope
  and intercept of the line. The area under the line in one-unit increments is
  calculated using
\deqn{\int_{x-1}^{x}mZ+b dZ = m(x-.5)+b}
where \code{m} is
  the slope, \code{b} is the intercept, and \code{x} is a distance. Integrating
  between \code{x-1} and \code{x} gives the probability between the one-unit
  increments.

  All of this is done for three size classes (bats, small birds (SB), and large
  birds (LB)) separately. An additional size class (RAPTOR) is included and
  identical to the large bird result.

  The \code{\link{floor}} function is applied to \code{lowerBound}.

  It is assumed that \code{hubHeight} and \code{bladeRadius} have the same units.
}
\examples{

triResult <- triangleProb(hubHeight = 100, bladeRadius = 50, lowerBound = 0)
names(triResult) ## list names
triResult$maxDist ## max distance for each size class
head(triResult$triDistProb)
}
\references{
Hull, C. L., & Muir, S. (2010).
  Search areas for monitoring bird and bat carcasses at wind farms using a Monte-Carlo model.
  Australasian Journal of Environmental Management, 17(2), 77-87.

Huso, M. & Dalthorp,D (2014).
Accounting for Unsearched Areas in Estimating Wind Turbine-Caused Fatality.
The Journal of Wildlife Management. 78. 10.1002/jwmg.663.
}
\seealso{
\code{\link{hullMuirMaxDistance}}
}
