% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{wk_count}
\alias{wk_count}
\alias{wk_count.default}
\alias{wk_count_handler}
\title{Count geometry components}
\usage{
wk_count(handleable, ...)

\method{wk_count}{default}(handleable, ...)

wk_count_handler()
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}},
\code{\link[=rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[=wk_handle]{wk_handle()}} is defined.}

\item{...}{Passed to the \code{\link[=wk_handle]{wk_handle()}} method.}
}
\value{
A data.frame with one row for every feature encountered and
columns:
\itemize{
\item \code{n_geom}: The number of geometries encountered, including the
root geometry. Will be zero for a null feature.
\item \code{n_ring}: The number of rings encountered. Will be zero for a
null feature.
\item \code{n_coord}: The number of coordinates encountered. Will be zero
for a null feature.
}
}
\description{
Counts the number of geometries, rings, and coordinates found within
each feature. As opposed to \code{\link[=wk_meta]{wk_meta()}}, this handler will iterate
over the entire geometry.
}
\examples{
wk_count(as_wkt("LINESTRING (0 0, 1 1)"))
wk_count(as_wkb("LINESTRING (0 0, 1 1)"))

}
