% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLOT_Sensitivity.R
\name{PlotSensitivity}
\alias{PlotSensitivity}
\title{PlotSensitivity}
\usage{
PlotSensitivity(Y = Y,
  main = "Sensitivity Estimate (dB) at each \\nlocation on visual field",
  legend.lab = "DLS (dB)", zlim, bins = 100, border = TRUE,
  legend = TRUE, color = c("yellow", "orange", "red"), legend.round = 0)
}
\arguments{
\item{Y}{variable to be plotted on the visual field (e.g. differential light sensitivity).}

\item{main}{an overall title for the plot.}

\item{legend.lab}{a label for the legend (default = "DLS (dB)").}

\item{zlim}{the limits used for the legend (default are the minimum and maximum of Y).}

\item{bins}{the number of bins used to refine the color palette for the figure and legend.}

\item{border}{logical, indicating whether there should be a border around the visual field (default = TRUE).}

\item{legend}{logical, indicating whether the legend should be present (default = TRUE).}

\item{color}{a vector of character strings representing the color palette.}

\item{legend.round}{integer, indicating the digits that the legend labels are rounded to
(default = 0).}
}
\description{
Plots a heat map of the differential light sensitivity on the Humphrey Field
Analyzer-II visual field.
}
\details{
\code{PlotSensitivity} is used in the application of glaucoma progression to
 plot a variable across the visual field in the form of a heat map.
}
\examples{
data(VFSeries)
PlotSensitivity(Y = VFSeries$DLS[VFSeries$Visit == 1],
                  main = "Sensitivity estimate (dB) at each \\n location on visual field",
                  legend.lab = "DLS (dB)",
                  zlim = c(10, 35),
                  bins = 250)
}
\author{
Samuel I. Berchuck
}

