#' WORCS checklist
#'
#' This checklist can be used to see whether a project adheres to the principles
#' of open reproducible code in science, as set out in the WORCS paper.
#'
#' \tabular{lll}{
#'   \strong{category} \tab \code{factor} \tab Category of the checklist
#'   element.\cr
#'   \strong{name} \tab \code{factor} \tab Name of the checklist
#'   element.\cr
#'   \strong{description} \tab \code{factor} \tab What are the requirements
#'   to claim that this checklist element is met?\cr
#'   \strong{importance} \tab \code{factor} \tab Whether the checklist
#'   element is essential to obtain a green 'open science' badge, or optional.\cr
#'   \strong{check} \tab \code{logical} \tab Whether the criterion is checked
#'   automatically by \code{\link{worcs_badge}}.
#' }
#' @docType data
#' @keywords datasets
#' @name worcs_checklist
#' @usage data(worcs_checklist)
#' @references Van Lissa, C. J., Brandmaier, A. M., Brinkman, L., Lamprecht, A.,
#' Peikert, A., , Struiksma, M. E., & Vreede, B. (2021)
#' \doi{10.3233/DS-210031}.
#
#' @format A data frame with 15 rows and 5 variables.
NULL
