% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_g2g.R
\name{network_g2g}
\alias{network_g2g}
\alias{g2g_network}
\title{Create a network plot with the group-to-group query}
\usage{
network_g2g(
  data,
  time_investor = NULL,
  collaborator = NULL,
  metric = "Collaboration_hours",
  algorithm = "fr",
  node_colour = "lightblue",
  exc_threshold = 0.1,
  org_count = NULL,
  subtitle = "Collaboration Across Organizations",
  return = "plot"
)

g2g_network(
  data,
  time_investor = NULL,
  collaborator = NULL,
  metric = "Collaboration_hours",
  algorithm = "fr",
  node_colour = "lightblue",
  exc_threshold = 0.1,
  org_count = NULL,
  subtitle = "Collaboration Across Organizations",
  return = "plot"
)
}
\arguments{
\item{data}{Data frame containing a G2G query.}

\item{time_investor}{String containing the variable name for the Time
Investor column.}

\item{collaborator}{String containing the variable name for the Collaborator
column.}

\item{metric}{String containing the variable name for metric. Defaults to
\code{Collaboration_hours}.}

\item{algorithm}{String to specify the node placement algorithm to be used.
Defaults to \code{"fr"} for the force-directed algorithm of Fruchterman and
Reingold. See
\url{https://rdrr.io/cran/ggraph/man/layout_tbl_graph_igraph.html} for a full
list of options.}

\item{node_colour}{String to specify the colour to be used for displaying
nodes. Defaults to \code{"lightblue"}. If \code{"vary"} is supplied, a different colour
is shown for each node at random.}

\item{exc_threshold}{Exclusion threshold to apply.}

\item{org_count}{Optional data frame to provide the size of each organization
in the \code{collaborator} attribute. The data frame should contain only two
columns:
\itemize{
\item Name of the \code{collaborator} attribute excluding any prefixes, e.g.
\code{"Organization"}. Must be of character or factor type.
\item \code{"n"}. Must be of numeric type.
Defaults to \code{NULL}, where node sizes will be fixed.
}}

\item{subtitle}{String to override default plot subtitle.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"table"}
\item \code{"network"}
\item \code{"data"}
}

See \code{Value} for more information.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: 'ggplot' object. A group-to-group network plot.
\item \code{"table"}: data frame. An interactive matrix of the network.
\item \verb{"network}: 'igraph' object used for creating the network plot.
\item \code{"data"}: data frame. A long table of the underlying data.
}
}
\description{
Pass a data frame containing a group-to-group query and return a network
plot. Automatically handles \code{"Collaborators_within_group"} and
\code{"Other_collaborators"} within query data.
}
\examples{
# Return a network plot
g2g_data \%>\% network_g2g()

# Return a network plot - Meeting hours and 5\% threshold
g2g_data \%>\%
  network_g2g(time_investor = "TimeInvestors_Organization",
              collaborator = "Collaborators_Organization",
              metric = "Meeting_hours",
              exc_threshold = 0.05)

# Return a network plot with circle layout
# Vary node colours and add org sizes
org_tb <- hrvar_count(
  sq_data,
  hrvar = "Organization",
  return = "table"
)

g2g_data \%>\%
  network_g2g(algorithm = "circle",
              node_colour = "vary",
              org_count = org_tb)

# Return an interaction matrix
# Minimum arguments specified
g2g_data \%>\%
  network_g2g(return = "table")


}
\seealso{
Other Network: 
\code{\link{external_network_plot}()},
\code{\link{g2g_data}},
\code{\link{internal_network_plot}()},
\code{\link{network_describe}()},
\code{\link{network_leiden}()},
\code{\link{network_louvain}()},
\code{\link{network_p2p}()},
\code{\link{p2p_data_sim}()}
}
\concept{Network}
