% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collaboration_report.R
\name{collaboration_report}
\alias{collaboration_report}
\title{Generate a Collaboration Report in HTML}
\usage{
collaboration_report(
  data,
  hrvar = "AUTO",
  mingroup = 5,
  path = "collaboration report",
  timestamp = TRUE
)
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{hrvar}{String containing the name of the HR Variable by which to split
metrics. Defaults to \code{"Organization"}. To run the analysis on the total
instead of splitting by an HR attribute, supply \code{NULL} (without quotes).}

\item{mingroup}{Numeric value setting the privacy threshold / minimum group
size. Defaults to 5.}

\item{path}{Pass the file path and the desired file name, \emph{excluding the file
extension}. For example, \code{"collaboration report"}.}

\item{timestamp}{Logical vector specifying whether to include a timestamp in
the file name. Defaults to \code{TRUE}.}
}
\value{
An HTML report with the same file name as specified in the arguments is
generated in the working directory. No outputs are directly returned by the
function.
}
\description{
The function generates an interactive HTML report using Standard Person Query
data as an input. The report contains a series of summary analysis and
visualisations relating to key \strong{collaboration} metrics in Workplace
Analytics,including email and meeting hours.
}
\seealso{
Other Reports: 
\code{\link{IV_report}()},
\code{\link{capacity_report}()},
\code{\link{coaching_report}()},
\code{\link{connectivity_report}()},
\code{\link{generate_report}()},
\code{\link{meeting_tm_report}()},
\code{\link{read_preamble}()},
\code{\link{subject_validate_report}()},
\code{\link{validation_report}()},
\code{\link{workpatterns_report}()}
}
\concept{Reports}
