% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_rank.R
\name{create_rank_combine}
\alias{create_rank_combine}
\title{Create combination pairs of HR variables and run 'create_rank()'}
\usage{
create_rank_combine(data, hrvar = extract_hr(data), metric, mingroup = 5)
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{hrvar}{String containing the name of the HR Variable by which to split
metrics. Defaults to \code{"Organization"}. To run the analysis on the total
instead of splitting by an HR attribute, supply \code{NULL} (without quotes).}

\item{metric}{Character string containing the name of the metric,
e.g. "Collaboration_hours"}

\item{mingroup}{Numeric value setting the privacy threshold / minimum group
size. Defaults to 5.}
}
\value{
Data frame containing the following variables:
\itemize{
\item \code{hrvar}: placeholder column that denotes the output as \code{"Combined"}.
\item \code{group}: pairwise combinations of HR attributes with the HR attribute
in square brackets followed by the value of the HR attribute.
\item Name of the metric (as passed to \code{metric})
\item \code{n}
}
}
\description{
Create pairwise combinations of HR variables and compute an
average of a specified advanced insights metric.
}
\details{
This function is called when the \code{mode} argument in \code{create_rank()} is
specified as \code{"combine"}.
}
\examples{
# Use a small sample for faster runtime
sq_data_small <- dplyr::slice_sample(sq_data, prop = 0.1)

create_rank_combine(
  data = sq_data_small,
  metric = "Email_hours"
)

}
