% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renameColumns.R
\name{.removeEmptyCol}
\alias{.removeEmptyCol}
\title{Search for (empty) columns conaining only entries defined in 'searchFields' and remove such columns}
\usage{
.removeEmptyCol(
  dat,
  fromBackOnly = TRUE,
  searchFields = c("", " ", "NA.", NA),
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix or data.frame) main input}

\item{fromBackOnly}{(logical)}

\item{searchFields}{(character)}

\item{silent}{(logical) suppres messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns a corrected matrix or data.frame
}
\description{
This function aims to search for (empty) columns conaining only entries defined in 'searchFields' and remove such columns.
If 'fromBackOnly' =TRUE .. only tailing empty columns will be removed (other columns with "empty" entries in middle will be kept).
If ''=TRUE columns containing all NAs will be excluded as well 
This function will also remove columns containing (exculsively) mixtures of the various 'searchFields'.
}
\examples{
ma1 <- matrix(c(1:5, NA), ncol=2)
.removeEmptyCol(ma1)
}
\seealso{
\code{\link{renameColumns}};  \code{\link[base]{is.finite}}
}
