% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeW2.R
\name{mergeW2}
\alias{mergeW2}
\title{Extended version of merge for multiple objects (even without rownames)}
\usage{
mergeW2(
  ...,
  nonRedundID = TRUE,
  convertDF = TRUE,
  selMerg = TRUE,
  inputNamesLst = NULL,
  noMatchPursue = TRUE,
  standColNa = FALSE,
  lastOfMultCols = c("p.value", "Lfdr"),
  duplTxtSep = "_",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{...}{all data (vectors, matrixes or data.frames) intendes for merge}

\item{nonRedundID}{(logical) if TRUE, allways add 1st column with non-redundant IDs (add anyway if non-redundant IDs found )}

\item{convertDF}{(logical) allows converting output in data.frame, add new heading col with non-red rownames & check which cols should be numeric}

\item{selMerg}{(logical) if FALSE toggle to classic merge() (will give more rows in output in case of redundant names}

\item{inputNamesLst}{(list) named list with character vectors (should be unique), search these names in input for extracting/merging elements use for 'lazy matching' when checking names of input, default : 7 groups ('Mvalue', 'Avalue','p.value','mouseInfo','Lfdr','link','filt') with common short versions}

\item{noMatchPursue}{(logical) allows using entries where 0 names match (just as if no names given)}

\item{standColNa}{(logical) if TRUE return standard colnames as defined in 'inputNamesLst' (ie 'chInp'), otherwise colnames as initially provided}

\item{lastOfMultCols}{may specify input groups where only last col will be used/extracted}

\item{duplTxtSep}{(character)  separator for counting/denomiating multiple occurances of same name}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) for bug-tracking: more/enhanced messages and intermediate objects written in global name-space}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
matrix or data.frame of fused data
}
\description{
\code{mergeW2} povides flexible merging out of 'MArrayLM'-object (if found, won't consider any other input-data) or of separate vectors or matrixes.
The main idea was to have somthing not adding add'l lines as merge might do, but to stay within the frame of the 1st argument given, even when IDs are repeated, 
so the output follows the order of the 1st argument, non-redundant IDs are created (orig IDs as new column).
If no 'MArrayLM'-object found: try to combine all elements of input '...', input-names must match predefined variants 'chInp'.
IDs given in 1st argument and not found in later arguments will be displayed as NA in the output matrix of data.frame.  
 Note : (non-data) arguments must be given with full name (so far no lazy evaluation, may conflict with names in 'inputNamesLst'). 
 Note : special characters in colnames bound to give trouble. 
 Note : when no names given, \code{mergeW2} will presume order of elements (names) from 'inputNamesLst'. 
PROBLEM : error after xxMerg3 when several entries have matching (row)names but some entries match only partially  (what to do : replace with NAs ??)
}
\examples{
t1 <- 1:10; names(t1) <- letters[c(1:7,3:4,8)]
t2 <- 20:11;  names(t2) <- letters[c(1:7,3:4,8)]
t3 <- 101:110; names(t3) <- letters[c(11:20)]
t4 <- matrix(100:81,ncol=2,dimnames=list(letters[1:10],c("co1","co2")))
t5 <- cbind(t1=t1,t52=t1+20,t53=t1+30)
  t1; t2; t3;  cbind(t1,t2)
mergeW2(Mval=t1,p.value=t2,debug=FALSE)
}
\seealso{
\code{\link[base]{merge}}
}
