% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeCsv.R
\name{writeCsv}
\alias{writeCsv}
\title{Write (and convert) csv files}
\usage{
writeCsv(
  input,
  inPutFi = NULL,
  expTy = c("Eur", "US"),
  imporTy = "Eur",
  filename = NULL,
  quote = FALSE,
  filterCol = NULL,
  replMatr = NULL,
  returnOut = FALSE,
  SYLKprevent = TRUE,
  digits = 22,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{input}{either matrix or data.frame}

\item{inPutFi}{(character or \code{NULL}) file-name to be read (format as US or Euro-type may specified via argument \code{imporTy})}

\item{expTy}{(character) 'US' and/or 'Eur' for sparator and decimal type in output}

\item{imporTy}{(character) default 'Eur' (otherwise set to 'US')}

\item{filename}{(character) optional new file name(s)}

\item{quote}{(logical) will be passed to \code{write.csv}}

\item{filterCol}{(integer or character) optionally, to export only the columns specified here}

\item{replMatr}{optional, matrix (1st line:search, 2nd li:use for replacing) indicating which characters need to be replaced )}

\item{returnOut}{(logical) return output as object}

\item{SYLKprevent}{(logical) prevent difficulty when opening file via Excel. In some cases Excel presumes (by error) the SYLK format and produces an error when trying to open files : 
To prevent this, if necessary, the 1st column-name will be changed from 'ID' to 'Id'.}

\item{digits}{(interger) limit number of signif digits in output (ie file)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) for bug-tracking: more/enhanced messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
writes file to disk and returns \code{NULL} unless \code{returnOut=TRUE}
}
\description{
This functions allows to write data into csv-files (and/or tabulated txt files) from given vector or read from file 'input' and (re-)write using specified conversions. 
An optional filter to select columns (column-name specified via 'filterCol') is available. 
The output may be simultaneaously written to multiple formats, as specified in 'expTy', 
tabulation characters may be converted to avoid accidentally split/shift text to multiple columns. 
Note: Mixing '.' and ',' as comma separators via text-columns or fused text&data may cause problems lateron, though.
}
\examples{
dat1 <- data.frame(ini=letters[1:5],x1=1:5,x2=11:15,t1=c("10,10","20.20","11,11","21,21","33.33"),
  t2=c("10,11","20.21","kl;kl","az,az","ze.ze"))
fiNa <- file.path(tempdir(),paste("test",1:2,".csv",sep=""))
writeCsv(dat1,filename=fiNa[1])
dir(path=tempdir(),pattern="cs")
(writeCsv(dat1,replM=rbind(bad=c(";",","),replBy="__"),expTy=c("Eur"),
  returnOut=TRUE,filename=fiNa[2]))

}
\seealso{
\code{write.csv} in \code{\link[utils]{write.table}}, batch reading using this package \code{\link{readCsvBatch}}
}
