% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clin_estimates.R
\name{eGFR}
\alias{eGFR}
\title{Estimation of glomerular filtration rate (eGFR) based on sex, age, and either serum creatinine and/or cystatin C}
\usage{
eGFR(data, age_var = "age", sex_var = "sex", crea_var = NULL, cys_var = NULL)
}
\arguments{
\item{data}{name of data set (tibble/data.frame) to analyze.}

\item{age_var}{name of column with patient age in years, default=age.}

\item{sex_var}{name of column with sex, assumed as female and male.}

\item{crea_var}{name of column with creatinine in mg/dl. If not available, leave as NULL.}

\item{cys_var}{name of column with cystatin C in mg/l. If not available, leave as NULL.}
}
\value{
A list with 3 elements:

eGFR_crea

eGFR_cystatin

eGFR_creatinine_cystatin
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{eGFR} computes eGFR according to different rules (see references).
}
\references{
https://www.kidney.org/content/ckd-epi-creatinine-cystatin-equation-2021

https://www.kidney.org/content/ckd-epi-creatinine-equation-2021

https://www.kidney.org/content/ckd-epi-cystatin-c-equation-2012
}
