% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{label_outliers}
\alias{label_outliers}
\title{Add labels to outliers in boxplot/beeswarm.}
\usage{
label_outliers(
  plotbase,
  labelvar = NULL,
  coef = 1.5,
  nudge_x = 0,
  nudge_y = 0,
  color = "darkred",
  size = 3,
  hjust = 0,
  face = "bold"
)
}
\arguments{
\item{plotbase}{ggplot object to add labels to.}

\item{labelvar}{variable to use as label. If NULL, rownames or rownumbers are used.}

\item{coef}{coefficient for boxplot.stats, defaults to 1.5.}

\item{nudge_x}{nudge in x direction, defaults to 0.}

\item{nudge_y}{nudge in y direction, defaults to 0.}

\item{color}{color of labels, defaults to darkred.}

\item{size}{size of labels, defaults to 3.}

\item{hjust}{horizontal justification of labels, defaults to 0.}

\item{face}{font face of labels, defaults to bold.}
}
\value{
A ggplot object, allowing further styling.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{label_outliers} adds a text_repel  layer to an existing ggplot object. It is intended to be used with boxplots or beeswarm plots. Faceting will result in separate computations for outliers.
It requires the \code{ggrepel} package.
}
