% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_tables.R
\name{partition_tables}
\alias{partition_tables}
\title{Partition as set of tables into a list.}
\usage{
partition_tables(
  tables_used,
  partition_column,
  ...,
  source_usage = NULL,
  source_limit = NULL,
  tables = NULL,
  env = NULL
)
}
\arguments{
\item{tables_used}{character, names of tables to look for.}

\item{partition_column}{character, name of column to partition by (tables should not have NAs in this column).}

\item{...}{force later arguments to bind by name.}

\item{source_usage}{optional named map from tables_used names to sets of columns used.}

\item{source_limit}{optional numeric scalar limit on rows wanted every source.}

\item{tables}{named map from tables_used names to data.frames.}

\item{env}{environment to also look for tables named by tables_used}
}
\value{
list of names maps of data.frames partitioned by partition_column.
}
\description{
Partition a set of tables into a list of sets of tables.  Note: removes rownames.
}
\examples{

d1 <- data.frame(a = 1:5, g = c(1, 1, 2, 2, 2))
d2 <- data.frame(x = 1:3, g = 1:3)
d3 <- data.frame(y = 1)
partition_tables(c("d1", "d2", "d3"), "g", tables = list(d1 = d1, d2 = d2, d3 = d3))

}
\seealso{
\code{\link{execute_parallel}}
}
