% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_order.R
\name{match_order}
\alias{match_order}
\title{Match one order to another.}
\usage{
match_order(ids1, ids2)
}
\arguments{
\item{ids1}{unique vector of ids.}

\item{ids2}{unique vector of ids with sort(ids1)==sort(ids2).}
}
\value{
p integers such that ids1[p] == ids2
}
\description{
Build a permutation p such that ids1[p] == ids2.  See \url{https://win-vector.com/2017/09/02/permutation-theory-in-action/}.
}
\examples{

ids1 <- c(4, 5, 7, 8, 9, 6, 1, 3, 2, 10)
ids2 <- c(3, 6, 4, 8, 5, 7, 1, 9,10, 2)
p <- match_order(ids1, ids2)
ids1[p]
all.equal(ids1[p], ids2)
# note base::match(ids2, ids1) also solves this problem

}
