% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_trim_na.R
\name{x3p_trim_na}
\alias{x3p_trim_na}
\title{Trim rows and columns with missing values only from an x3p}
\usage{
x3p_trim_na(x3p, ratio = 1)
}
\arguments{
\item{x3p}{x3p object}

\item{ratio}{ratio between zero and one, indicating the percent of values that need to be missing in each row and column, for the row or column to be removed}
}
\value{
x3p object of the same or smaller dimension where missing values are removed from the boundaries
}
\description{
Trims rows and columns from the edges of a surface matrix that contain missing values only.
}
\examples{
logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
logo$surface.matrix[logo$surface.matrix == median(logo$surface.matrix)] <- NA
x3p_trim_na(logo) # reduced to dimension: 668 by 268
}
