% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editable.R
\name{editable}
\alias{editable}
\alias{use_editable}
\alias{html_dependency_editable}
\title{Editable}
\usage{
use_editable(id = NULL, expires = 14)

html_dependency_editable(expires = 14, id = NULL)
}
\arguments{
\item{id}{Optional. By default, when \code{id} is \code{NULL}, each re-generation of
your slides creates a new document ID. This way, values that were
previously stored in the browser for an older version of your slides will
not be loaded into a new version. If you are confident that the editable
fields in your slides are not changing between versions, you can set the
document ID so that newer versions of your slides will continue to load
edited values from previous versions in the browser.}

\item{expires}{Editable values that also have a \code{.key-KEYNAME} class are
stored in the browser and automatically loaded when the slides are
reloaded. These values are stored using cookies so that they can eventually
expire and \code{expires} provides the number of days that those values should
be stored before being released.}
}
\value{
An \code{htmltools::tagList()} with the editable dependencies, or an
\link[htmltools:htmlDependency]{htmltools::htmlDependency}.
}
\description{
Editable gives you a way to write directly inside your slides. Make any
element of your slides editable by using the \code{.can-edit[...]} class. Editable
fields are reset when the slides are reloaded, but it is possible for edits
to persist across sessions (in the same browser) by giving the editable
element a \verb{.key-<NAME>} class, where \verb{<NAME>} is a unique identifier (and
valid CSS class).
}
\section{Functions}{
\itemize{
\item \code{use_editable}: Adds editable to your xaringan slides.

\item \code{html_dependency_editable}: Returns an \link[htmltools:htmlDependency]{htmltools::htmlDependency} with the tile
view dependencies. Most users will want to use \code{use_editable()}.
}}

\section{Usage}{
 To make your xaringan presentations \emph{editable}, add the
following code chunk to your slides' R Markdown file.

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{```\{r xaringan-editable, echo=FALSE\}
# Setup editable fields and only store values in the browser for one day
# (by default values expire in 2 weeks).
xaringanExtra::use_editable(expires = 1)
```
}\if{html}{\out{</div>}}

Then, to make a component of your slides editable, use the \code{.can-edit[]}
class.

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{## .can-edit[You can edit this slide title]
}\if{html}{\out{</div>}}

Editable fields that only have the \code{.can-edit} class are reset whenever the
slides are re-loaded in your browser. If you want to store the edited
values and have them persist across browser sessions, give each editable
field a \verb{.key-<NAME>} class. Be sure to make each key unique and note that
the key name must be a valid CSS class, i.e. it cannot contain spaces.

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{## .can-edit.key-firstSlideTitle[Change this title and then reload the page]
}\if{html}{\out{</div>}}

\strong{Warning} Editable fields may not work well with slide continuations. If
your full slide builds up over several slides, you can only edit the
currently visible slide. If the field has a key, however, all editable
elements with the same key class are updated when the slides are loaded.
In other words, you can edit the title on the first slide of a multi-part
slide and reload the page to have the title applied to subsequent slides.
}

\examples{
use_editable()

}
