% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{compileShortPT}
\alias{compileShortPT}
\title{Produces a production table with non-recursive productions only.}
\usage{
compileShortPT(G)
}
\arguments{
\item{G}{A grammar with symbol table \code{ST}, 
production table \code{PT}, 
and start symbol \code{Start}.}
}
\value{
A (short) production table is a named list with 2 columns.
        The first column
        (the left-hand side \code{LHS}) is a vector
        of non-terminal identifiers. 
        The second column
        (the right-hand side \code{RHS}) is a 
        vector of vectors of numerical identifiers. 
        \code{LHS[i]} derives into \code{RHS[i]}.
}
\description{
\code{compileShortPT()} produces a ``short'' production table 
              from a context-free grammar. The short production table does not
              contain recursive production rules.  
              Warning: No error checking implemented.
}
\details{
\code{compileShortPT()} starts with production rules whose 
         right-hand side contains only terminals. 
         It incrementally builds up the new PT until at least one
         production rule sequence from a non-terminal to a terminal symbol.

         The short production rule provides for each non-terminal 
         symbol a minimal finite derivation into terminals. 
         Instead
         of the full production table, it is used
         for generating depth-bounded derivation trees.
}
\examples{
g<-compileBNF(booleanGrammar())
compileShortPT(g)

}
