% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revcheck.R
\name{rev_check}
\alias{rev_check}
\alias{compare_Rcheck}
\title{Run \command{R CMD check} on the reverse dependencies of a package}
\usage{
rev_check(
  pkg,
  which = "all",
  recheck = NULL,
  ignore = NULL,
  update = TRUE,
  timeout = getOption("xfun.rev_check.timeout", 15 * 60),
  src = file.path(src_dir, pkg),
  src_dir = getOption("xfun.rev_check.src_dir")
)

compare_Rcheck(status_only = FALSE, output = "00check_diffs.md")
}
\arguments{
\item{pkg}{The package name.}

\item{which}{Which types of reverse dependencies to check. See
\code{tools::\link[tools]{package_dependencies}()} for possible values. The
special value \code{'hard'} means the hard dependencies, i.e.,
\code{c('Depends', 'Imports', 'LinkingTo')}.}

\item{recheck}{A vector of package names to be (re)checked. If not provided
and there are any \file{*.Rcheck} directories left by certain packages
(this often means these packages failed the last time), \code{recheck} will
be these packages; if there are no \file{*.Rcheck} directories but a text
file \file{recheck} exists, \code{recheck} will be the character vector
read from this file. This provides a way for you to manually specify the
packages to be checked. If there are no packages to be rechecked, all
reverse dependencies will be checked.}

\item{ignore}{A vector of package names to be ignored in \command{R CMD
check}. If this argument is missing and a file \file{00ignore} exists, the
file will be read as a character vector and passed to this argument.}

\item{update}{Whether to update all packages before the check.}

\item{timeout}{Timeout in seconds for \command{R CMD check}.}

\item{src}{The path of the source package directory.}

\item{src_dir}{The parent directory of the source package directory. This can
be set in a global option if all your source packages are under a common
parent directory.}

\item{status_only}{If \code{TRUE}, only compare the final statuses of the
checks (the last line of \file{00check.log}), and delete \file{*.Rcheck}
and \file{*.Rcheck2} if the statuses are identical, otherwise write out the
full diffs of the logs. If \code{FALSE}, compare the full logs under
\file{*.Rcheck} and \file{*.Rcheck2}.}

\item{output}{The output Markdown file to which the diffs in check logs will
be written. If the \pkg{markdown} package is available, the Markdown file
will be converted to HTML, so you can see the diffs more clearly.}
}
\description{
Install the source package, figure out the reverse dependencies on CRAN,
download all of their source packages, and run \command{R CMD check} on them
in parallel.
}
\details{
Everything occurs under the current working directory, and you are
recommended to call this function under a designated directory, especially
when the number of reverse dependencies is large, because all source packages
will be downloaded to this directory, and all \file{*.Rcheck} directories
will be generated under this directory, too.

If a source tarball of the expected version has been downloaded before (under
the \file{tarball} directory), it will not be downloaded again (to save time
and bandwidth).

After a package has been checked, the associated \file{*.Rcheck} directory
will be deleted if the check was successful (no warnings or errors or notes),
which means if you see a \file{*.Rcheck} directory, it means the check
failed, and you need to take a look at the log files under that directory.

The time to finish the check is recorded for each package. As the check goes
on, the total remaing time will be roughly estimated via \code{n *
mean(times)}, where \code{n} is the number of packages remaining to be
checked, and \code{times} is a vector of elapsed time of packages that have
been checked.

If a check on a reverse dependency failed, its \file{*.Rcheck} directory will
be renamed to \file{*.Rcheck2}, and another check will be run against the
CRAN version of the package. If the logs of the two checks are the same, it
means no new problems were introduced in the package, and you can probably
ignore this particular reverse dependency. The function
\code{compare_Rcheck()} can be used to create a summary of all the
differences in the check logs under \file{*.Rcheck} and \file{*.Rcheck2}.
This will be done automatically if \code{options(xfun.rev_check.summary =
TRUE)} has been set.

A recommended workflow is to use a special directory to run
\code{rev_check()}, set the global \code{\link{options}}
\code{xfun.rev_check.src_dir} and \code{repos} in the R startup (see
\code{?\link{Startup}}) profile file \code{.Rprofile} under this directory,
and (optionally) set \code{R_LIBS_USER} in \file{.Renviron} to use a special
library path (so that your usual library will not be cluttered). Then run
\code{xfun::rev_check(pkg)} once, investigate and fix the problems or (if you
believe it was not your fault) ignore broken packages in the file
\file{00ignore}, and run \code{xfun::rev_check(pkg)} again to recheck the
failed packages. Repeat this process until all \file{*.Rcheck} directories
are gone.

As an example, I set \code{options(repos = c(CRAN =
'https://cran.rstudio.com'), xfun.rev_check.src_dir = '~/Dropbox/repo')} in
\file{.Rprofile}, and \code{R_LIBS_USER=~/R-tmp} in \file{.Renviron}. Then I
can run, for example, \code{xfun::rev_check('knitr')} repeatedly under a
special directory \file{~/Downloads/revcheck}. Reverse dependencies and their
dependencies will be installed to \file{~/R-tmp}, and \pkg{knitr} will be
installed from \file{~/Dropbox/repo/kintr}.
}
\seealso{
\code{devtools::revdep_check()} is more sophisticated, but currently
  has a few major issues that affect me: (1) It always deletes the
  \file{*.Rcheck} directories
  (\url{https://github.com/hadley/devtools/issues/1395}), which makes it
  difficult to know more information about the failures; (2) It does not
  fully install the source package before checking its reverse dependencies
  (\url{https://github.com/hadley/devtools/pull/1397}); (3) I feel it is
  fairly difficult to iterate the check (ignore the successful packages and
  only check the failed packages); by comparison, \code{xfun::rev_check()}
  only requires you to run a short command repeatedly (failed packages are
  indicated by the existing \file{*.Rcheck} directories, and automatically
  checked again the next time).

  \code{xfun::rev_check()} borrowed a very nice feature from
  \code{devtools::revdep_check()}: estimating and displaying the remaining
  time. This is particularly useful for packages with huge numbers of reverse
  dependencies.
}
