% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{tojson}
\alias{tojson}
\alias{json_vector}
\title{A simple JSON serializer}
\usage{
tojson(x)

json_vector(x, to_array = FALSE, quote = TRUE)
}
\arguments{
\item{x}{An R object.}

\item{to_array}{Whether to convert a vector to a JSON array (use \code{[]}).}

\item{quote}{Whether to double quote the elements.}
}
\value{
A character string.
}
\description{
A JSON serializer that only works on a limited types of R data (\code{NULL},
lists, logical scalars, character/numeric vectors). The function
\code{json_vector()} converts an atomic R vector to JSON.
}
\examples{
library(xfun)
tojson(NULL)
tojson(1:10)
tojson(TRUE)
tojson(FALSE)
cat(tojson(list(a = 1, b = list(c = 1:3, d = "abc"))))
cat(tojson(list(c("a", "b"), 1:5, TRUE)))
}
