% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_bin}
\alias{read_bin}
\title{Read all records of a binary file as a raw vector by default}
\usage{
read_bin(file, what = "raw", n = file.info(file)$size, ...)
}
\arguments{
\item{file, what, n, ...}{Arguments to be passed to \code{readBin()}.}
}
\value{
A vector returned from \code{readBin()}.
}
\description{
This is a wrapper function of \code{\link{readBin}()} with default arguments
\code{what = "raw"} and \code{n = \link{file.size}(file)}, which means it
will read the full content of a binary file as a raw vector by default.
}
\examples{
f = tempfile()
cat("abc", file = f)
xfun::read_bin(f)
unlink(f)
}
