% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gxs_selection.R
\name{gxs_selection}
\alias{gxs_selection}
\title{Generate testhat expectations from selection}
\usage{
gxs_selection(
  selection,
  indentation = 0,
  tolerance = "1e-4",
  round_to_tolerance = TRUE,
  strip = TRUE,
  sample_n = 30,
  envir = NULL,
  assign_output = TRUE,
  seed = 42,
  test_id = NULL,
  add_wrapper_comments = TRUE,
  add_test_comments = TRUE,
  start_with_newline = TRUE,
  end_with_newline = TRUE,
  out = "insert"
)
}
\arguments{
\item{selection}{String of code. (Character)

E.g. \code{"stop('This gives an expect_error test')"}.}

\item{indentation}{Indentation of the selection. (Numeric)}

\item{tolerance}{The tolerance for numeric tests as a string, like \code{"1e-4"}. (Character)}

\item{round_to_tolerance}{Whether to round numeric elements to the specified tolerance. (Logical)

This is currently applied to numeric columns and vectors (excluding some lists).}

\item{strip}{Whether to insert
\code{\link[xpectr:strip]{strip_msg()}} and
\code{\link[xpectr:strip]{strip()}}
in tests of side effects. (Logical)

Sometimes testthat tests have differences in punctuation and newlines on different
systems. By stripping both the error message and the expected message of non-alphanumeric symbols,
we can avoid such failed tests.}

\item{sample_n}{The number of elements/rows to sample. Set to \code{NULL} to avoid sampling.

Inserts \code{\link[xpectr:strip]{smpl()}} in the generated tests when sampling was used. A seed is
set internally, setting \code{sample.kind} as \code{"Rounding"} to ensure compatibility with R versions
\code{< 3.6.0}.

The order of the elements/rows is kept intact. No replacement is used, why no oversampling will
take place.

When testing a big data frame, sampling the rows can help keep the test files somewhat readable.}

\item{envir}{Environment to evaluate in.}

\item{assign_output}{Whether to assign the output of a function call or long selection
to a variable. This will avoid recalling the function and decrease cluttering. (Logical)

Heuristic: when the \code{selection} isn't of a string and contains a parenthesis, it is considered a function call.
A selection with more than 30 characters will be assigned as well.

The tests themselves can be more difficult to interpret, as you will
have to look at the assignment to see the object that is being tested.}

\item{seed}{Seed to set. (Whole number)}

\item{test_id}{Number to append to assignment names. (Whole number)

For instance used to create the "output_" name: \code{output_<test_id>}.}

\item{add_wrapper_comments}{Whether to add intro and outro comments. (Logical)}

\item{add_test_comments}{Whether to add comments for each test. (Logical)}

\item{start_with_newline, end_with_newline}{Whether to have a newline in the beginning/end. (Logical)}

\item{out}{Either \code{"insert"} or \code{"return"}.

\subsection{"insert" (Default)}{
Inserts the expectations via
\code{\link[rstudioapi:insertText]{rstudioapi::insertText()}}.
}
\subsection{"return"}{
Returns the expectations in a list.

These can be prepared for insertion with
\code{\link[xpectr:prepare_insertion]{prepare_insertion()}}.
}}
}
\value{
Either \code{NULL} or the unprepared expectations as a character vector.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Based on the selection (string of code), a set of testthat \code{expect_*}
statements are generated.

Example: If the selected code is the name of a data frame object,
it will create an \code{\link[testthat:expect_equal]{expect_equal}}
test for each column, along with a test of the column names,
types and classes, dimensions, grouping keys, etc.

See supported objects in \code{details}.

Feel free to suggest useful tests etc. in a GitHub issue!

Addin: \code{\link[xpectr:insertExpectationsAddin]{insertExpectationsAddin()}}
}
\details{
The following "types" are currently supported or intended to be supported in the future.
Please suggest more types and tests in a GitHub issue!

Note: A set of fallback tests will be generated for unsupported objects.

\tabular{rrr}{
\strong{Type} \tab \strong{Supported} \tab \strong{Notes} \cr
Side effects \tab Yes \tab Errors, warnings, and messages. \cr
Vector \tab Yes \tab Lists are treated differently, depending on their structure. \cr
Factor \tab Yes \tab \cr
Data Frame \tab Yes \tab List columns (like nested tibbles) are currently skipped. \cr
Matrix \tab Yes \tab Supported but could be improved. \cr
Formula \tab Yes \tab \cr
Function \tab Yes \tab \cr
\code{NULL} \tab Yes \tab \cr
Array \tab No \tab \cr
Dates \tab No \tab Base and \code{lubridate}. \cr
ggplot2 \tab No \tab This may be a challenge, but would be cool!\cr
}
}
\examples{
# Attach packages
library(xpectr)

\donttest{
df <- data.frame('a' = c(1, 2, 3), 'b' = c('t', 'y', 'u'),
                 stringsAsFactors = FALSE)

gxs_selection("stop('This gives an expect_error test!')")
gxs_selection("warning('This gives a set of side effect tests!')")
gxs_selection("message('This also gives a set of side effect tests!')")
gxs_selection("stop('This: tests the -> punctuation!')", strip = FALSE)
gxs_selection("sum(1, 2, 3, 4)")
gxs_selection("df")

tests <- gxs_selection("df", out = "return")
for_insertion <- prepare_insertion(tests)
rstudioapi::insertText(for_insertion)
}
}
\seealso{
Other expectation generators: 
\code{\link{gxs_function}()},
\code{\link{insertExpectationsAddin}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{expectation generators}
