% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_csv.R
\name{io_csv.character}
\alias{io_csv.character}
\title{Import Documented Table as CSV}
\usage{
\method{io_csv}{character}(
  x,
  ext = getOption("yamlet_extension", ".yaml"),
  meta = NULL,
  gz = NULL,
  ...
)
}
\arguments{
\item{x}{character file path; passed to \code{\link[csv]{as.csv.character}} (by method dispatch)}

\item{ext}{extension for metadata equivalent of x}

\item{meta}{explicit file path for metadata; if null, \code{ext} is appended to x after removing (final) extension, if any}

\item{gz}{logical; guessed by default from \code{x}; if TRUE, '.gz' extension enforced present for \code{x} and absent for default \code{meta}}

\item{...}{passed to \code{\link[csv]{as.csv.character}} and to \code{\link{decorate}}}
}
\value{
data.frame
}
\description{
Imports a documented table as comma-separated variable.
A wrapper for \code{\link[csv]{as.csv.character}} that also
reads associated yamlet metadata, if present, and applies it
as attributes.
}
\examples{
example(io_csv)
}
\seealso{
Other io: 
\code{\link{io_csv.data.frame}()},
\code{\link{io_csv}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_res}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_table}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()},
\code{\link{io_yamlet}()}

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{io}
\keyword{internal}
