% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimonious.R
\name{parsimonious.list}
\alias{parsimonious.list}
\title{Reduce A List to its Simplest Sufficient Version}
\usage{
\method{parsimonious}{list}(x, ...)
}
\arguments{
\item{x}{object of dispatch}

\item{...}{passed arguments}
}
\value{
list
}
\description{
Reduces a list to its simplest sufficient version.
Used internally with \code{\link[yaml]{yaml.load}}
as a custom handler for objects of type 'seq'.
Consider: \code{str(yaml.load('[a: 1, b: 2]'))}.
The result is technically correct. By default,
the parser returns a sequence of two maps.
Not reducible to a base type,
The sequence is an anonymous list.
The maps themselves are named lists.
In the special case that all elements are of length one,
this structure can be collapsed without semantic loss
to a named list.
More generally, if an anonymous list consists entirely
of length one members, those members which are
lists (but not already parsimonious lists)
can be replaced with their first elements;
the list becomes named if any of those elements
has a name. In that case, any elements without
names get the name '' (empty string).
}
\examples{
library(magrittr)
library(yaml)
# Parsimonious:
'[a: 1, b: 2]' \%>\% yaml.load
'[a: 1, b: 2]' \%>\% yaml.load(handlers = list(seq = parsimonious))

# No effect on vector types:
'[1, 2]' \%>\% yaml.load
'[1, 2]' \%>\% yaml.load(handlers = list(seq = parsimonious))

# Respects mixed-length vector types:
'RACE: [ race, [white, black, asian ]]' \%>\% yaml.load
'RACE: [ race, [white, black, asian ]]' \%>\% yaml.load(handlers = list(seq = parsimonious))

# Anonymous elements get a blank name:
'[a: 1, 2]' \%>\% yaml.load \%>\% sapply(names)
'[a: 1, 2]' \%>\% yaml.load(handlers = list(seq = parsimonious)) \%>\% names

# Also works for sequence of length one:
'[a: 1]' \%>\% yaml.load
'[a: 1]' \%>\% yaml.load(handlers = list(seq = parsimonious))

# Works for NULL:
yaml.load('-')
yaml.load('-', handlers = list(seq = parsimonious))

# And for empty list:
yaml.load('[]')
yaml.load('[]', handlers = list(seq = parsimonious))

# Limited to first (most deeply nested) encounter:
'[[[a: 1]]]' \%>\% yaml.load
'[[[a: 1]]]' \%>\% yaml.load(handlers = list(seq = parsimonious))

# Works for mixed-depth nesting:
'ITEM: [ label: item, [ foo: bar, hey: baz ]]' \%>\% yaml.load
'ITEM: [ label: item, [ foo: bar, hey: baz ]]' \%>\% yaml.load(handlers = list(seq = parsimonious))
}
\seealso{
Other parsimonious: 
\code{\link{parsimonious}()},
\code{\link{parsimonious.default}()}
}
\concept{parsimonious}
\keyword{internal}
