% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fstrcapture.R
\name{fstrcapture}
\alias{fstrcapture}
\title{Capture string tokens into a data frame}
\usage{
fstrcapture(pattern, x, proto, perl = TRUE, useBytes = FALSE)
}
\arguments{
\item{pattern}{
    The regular expression with the capture expressions.
  }

\item{x}{
    A character vector in which to capture the tokens.
  }

\item{proto}{
    A \code{data.frame} or S4 object that behaves like one. See details.
  }

\item{perl}{Should Perl-compatible regexps be used?}

\item{useBytes}{If TRUE the matching is done byte-by-byte rather than
character-by-character.}
}
\value{
A tabular data structure of the same type as proto, so typically a data.frame,
containing a column for each capture expression. The column types and names
are inherited from proto. Cases in x that do not match pattern have NA in
every column.
}
\description{
\code{fstrcapture()} is a replacement for \code{\link[=strcapture]{strcapture()}} with better performance
when \code{perl = TRUE}.
}
\note{
Compared to \code{\link[=strcapture]{strcapture()}}, \code{fstrcapture()} sets the default value for \code{perl}
to \code{TRUE}. Apart from this it can be used as a drop-in replacement.
}
\examples{

x <- "chr1:1-1000"
pattern <- "(.*?):([[:digit:]]+)-([[:digit:]]+)"
proto <- data.frame(chr=character(), start=integer(), end=integer())
fstrcapture(pattern, x, proto)

}
\seealso{
\code{\link[=strcapture]{strcapture()}} for further details.
}
