% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertAllYaml2RDataframesT20.R
\name{convertAllYaml2RDataframesT20}
\alias{convertAllYaml2RDataframesT20}
\title{Convert and save all T20 Yaml files  to dataframes}
\usage{
convertAllYaml2RDataframesT20(sourceDir=".",targetDirMen=".",targetDirWomen=".")
}
\arguments{
\item{sourceDir}{The source directory of the yaml files}

\item{targetDirMen}{The target directory in which the data frames of men are stored as RData files}

\item{targetDirWomen}{The target directory in which the data frames of women are stored as RData files}
}
\value{
None
}
\description{
This function coverts all T20 Yaml files from source directory to data frames. The data frames
are then stored as .RData. The saved files are of the format team1-team2-date.RData
For e.g. England-India-2008-04-06.RData etc
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# In the example below ../yamldir is the source dir for the yaml files
convertAllYaml2RDataframesT20("../yamldir","../data")
}
}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{bowlerMovingAverage}}\cr
\code{\link{bowlerWicketPlot}}\cr
\code{\link{bowlerWicketsVenue}}\cr
\code{\link{convertYaml2RDataframeT20}}\cr
}
\author{
Tinniam V Ganesh
}
