% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBowlersVsBatsmenOppnAllMatches.R
\name{teamBowlersVsBatsmenOppnAllMatches}
\alias{teamBowlersVsBatsmenOppnAllMatches}
\title{Team bowlers vs batsmen against an opposition in all matches}
\usage{
teamBowlersVsBatsmenOppnAllMatches(matches,main,opposition,plot=1,top=5)
}
\arguments{
\item{matches}{The data frame of all matches between a team the opposition. This dataframe can be obtained with
matches <- getAllMatchesBetweenTeams("Australia","India",dir="../data")}

\item{main}{The main team against which the performance is requires}

\item{opposition}{The opposition team against which the performance is require}

\item{plot}{plot=1 (static),plot=2(interactive),plot=3(table)}

\item{top}{The number of rows to be returned. 5 by default}
}
\value{
dataframe
The dataframe with all performances
}
\description{
This function computes performance of bowlers of a team against an opposition in all matches
against the opposition
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches between India and Australia
matches <- getAllMatchesBetweenTeams("Australia","India",dir="../data")

#  Plot the performance of top 5 Indian bowlers against Australia
teamBowlersVsBatsmanOppnAllMatches(matches,'India',"Australia",top=5)

# Plot the performance of top 3 Australian bowlers against India
teamBowlersVsBatsmenOppnAllMatches(matches,"Australia","India",top=3)

# Get the top 5 bowlers of Australia. Do not plot but get as a dataframe
teamBowlersVsBatsmenOppnAllMatches(matches,"Australia","India",plot=FALSE)
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{teamBatsmenPartnershipAllOppnAllMatches}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
\code{\link{teamBowlersVsBatsmenAllOppnAllMatchesRept}}\cr
\code{\link{teamBowlersVsBatsmenAllOppnAllMatchesPlot}}\cr
}
\author{
Tinniam V Ganesh
}
