% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zVarArray.R
\name{zVarArray}
\alias{zVarArray}
\title{Variation array for grouped data}
\usage{
zVarArray(X, label = 0, groups = NULL, suppress.print = FALSE)
}
\arguments{
\item{X}{Compositional data set (\code{\link{matrix}} or \code{\link{data.frame}} class).}

\item{label}{Unique label (\code{\link{numeric}} or \code{\link{character}}) used to denote zeros/unobserved data in \code{X} (\code{label = 0}, default).}

\item{groups}{Grouping factor in fully observed zero-free data sets (\code{groups = NULL}, default).}

\item{suppress.print}{Suppress printed feedback (\code{suppress.print = FALSE}, default).}
}
\value{
List of variation arrays by pattern/group and overall.
}
\description{
This function returns overall and separate variation arrays for groups
in a compositional data set. Groups can be defined by either zero/unobserved data patterns or
by a grouping factor in fully observed zero-free data sets.
}
\details{
This function is mainly aimed to investigate heterogeneous relative variation
structures in compositional data sets containing zeros or unobserved values. For each pattern of zero or unobserved values,
log-ratio variances (upper triangle of variation matrix) and means (lower triangle of variation matrix) are computed from the
available data. Note that (1) NAs are produced for log-ratio variances and means in groups containing less than two observations,
and (2) at least two components must be available in each group to compute log-ratios.

The overall estimate is obtained across groups by pairwise deletion. Note that, unlike the ordinary \code{\link{var}}
function, maximum likelihood estimates of the variances are computed. That is,
the observed sum of squares is divided by the corresponding number of observations n and not by n-1.

Group-wise variation arrays can be obtained from fully observed zero-free data by setting a grouping factor
using the argument \code{groups}.
}
\examples{
data(Water)
zPatterns(Water, label = 0)
zVarArray(Water)

# From a completed data set

data(mdl) # matrix of limits of detection for Water
Water_multKM <- multKM(Water,label=0,dl=mdl) # nondetects imputation

# Results split by two ficticious groups A and B
zVarArray(Water_multKM,groups=rep(c("A","B"),each=50))
}
\seealso{
\code{\link{zPatterns}}.
}
