% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{power_to_z}
\alias{power_to_z}
\title{Compute power corresponding to z-scores}
\usage{
power_to_z(
  power,
  alpha = 0.05,
  a = stats::qnorm(alpha/2, lower.tail = FALSE),
  nleqslv_control = list(xtol = 1e-15, maxit = 300, stepmax = 0.5)
)
}
\arguments{
\item{power}{A vector of z-scores}

\item{alpha}{Level of significance alpha}

\item{a}{Or, alternatively a z-score corresponding to \code{alpha}}

\item{nleqslv_control}{A named list of control parameters passed to the
\link[nleqslv]{nleqslv} function used for solving the inverse of
\link[=z_to_power]{z_to_power} function.}
}
\description{
A function for computing z-scores of two-sided tests
corresponding to power for a given significance level.
}
\examples{
# z-scores corresponding to the (aproximate) power of components of EM7p
power_to_z(c(0.05, 0.20, 0.40, 0.60, 0.80, 0.974, 0.999), alpha = .05)
}
