% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{rescale.regular}
\alias{rescale.regular}
\title{Rescaling of data following a hierarchical increase in grain size}
\usage{
rescale.regular(xy, data.spec, data.env = NULL, method = "mean", n)
}
\arguments{
\item{xy}{Site-by-coordinate data frame, with sites as rows and coordinates as columns.}

\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{data.env}{Site-by-variable data frame, with sites as rows and environmental variables as columns.}

\item{method}{Name of a function (as a string) indicating how to combine the coordinates and the environmental variables. It can be a basic R-function such as "\code{mean}" or "\code{max}", but also a custom function.}

\item{n}{Mapping grain (the number of sites combined to generate data at a coarser grain). Regularly spaced sites are grouped as \code{n} x \code{n} sites.}
}
\value{
\code{rescale.regular} returns a data frame with the rescaled data.
}
\description{
Increases grain by hierarchically nesting regularly spaced sites.
}
\details{
The sites (plots or quadrates) are aggregated as nearest neighbouring groups of \code{n} x \code{n} sites, using a nested approach, starting from the lowest x and y, to increase the grain. The sites can be spatially contiguous or discontiguous, as long as they are regularly spaced. This function is not suitable for irregularly spaced sites. If the total number of sites is not a multiple of \code{n} x \code{n}, the extra sites are discarded.
}
\examples{

utils::data(bird.spec.fine)
xy.bird <- bird.spec.fine[1:2]
data.spec.bird <- bird.spec.fine[3:192]

data.rescale <- rescale.regular(xy.bird, data.spec.bird, n = 4)
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.

Scheiner S.M., Chiarucci A., Fox G.A., Helmus M.R., McGlinn D.J. & Willig M.R. (2011). The underpinnings of the relationship of species richness with space and time. \emph{Ecological Monographs}, 81, 195-213.
}
\seealso{
\code{\link{Zeta.decline.mc}}, \code{\link{Zeta.order.mc}}, \code{\link{Zeta.decline.ex}}, \code{\link{Zeta.order.ex}}, \code{\link{Zeta.scale.regular}}, \code{\link{Zeta.scale.min.dist}}, \code{\link{rescale.min.dist}}
}

