% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{pie.neg}
\alias{pie.neg}
\title{Pie Chart, considering negative values as zeros}
\usage{
pie.neg(
  x,
  labels = names(x),
  edges = 200,
  radius = 0.8,
  clockwise = FALSE,
  init.angle = if (clockwise) 90 else 0,
  density = NULL,
  angle = 45,
  col = NULL,
  border = NULL,
  lty = NULL,
  main = NULL,
  warning = TRUE,
  ...
)
}
\arguments{
\item{x}{A vector of non-negative numerical quantities. The values in x are displayed as the areas of pie slices.}

\item{labels}{One or more expressions or character strings giving names for the slices. Other objects are coerced by \code{\link[grDevices]{as.graphicsAnnot}}. For empty or NA (after coercion to character) labels, no label nor pointing line is drawn.}

\item{edges}{The circular outline of the pie is approximated by a polygon with this many edges.}

\item{radius}{The pie is drawn centered in a square box whose sides range from -1 to 1. If the character strings labeling the slices are long it may be necessary to use a smaller radius.}

\item{clockwise}{Logical indicating if slices are drawn clockwise or counter clockwise (i.e., mathematically positive direction, used by default).}

\item{init.angle}{number specifying the starting angle (in degrees) for the slices. Defaults to 0 (i.e., '3 o'clock') unless clockwise is true where init.angle defaults to 90 (degrees), (i.e., '12 o'clock').}

\item{density}{The density of shading lines, in lines per inch. The default value of NULL means that no shading lines are drawn. Non-positive values of density also inhibit the drawing of shading lines.}

\item{angle}{The slope of shading lines, given as an angle in degrees (counter-clockwise).}

\item{col}{A vector of colors to be used in filling or shading the slices. If missing a set of 6 pastel colours is used, unless density is specified when par("fg") is used.}

\item{border, lty}{(possibly vectors) arguments passed to polygon which draws each slice.}

\item{main}{An overall title for the plot.}

\item{warning}{Boolean value. Set to FALSE to avoid displaying a warning if some values are negative and set to 0.}

\item{...}{Graphical parameters can be given as arguments to pie. They will affect the main title and labels only.}
}
\description{
Plots a pie chart, considering negative values as zeros, for the purpose of illustrating variation partitioning.
}
\details{
This function is identical to the function \code{\link[graphics]{pie}} in \{graphics\}, except that it considers all negative values as zeros, to allow for plotting variation partitioning outputs. The original \code{\link[graphics]{pie}} function returns an error when negative values are present. However, variation partitioning can return negative values, which can then be treated as zeros (Legendre & Legendre, 2008). This function allows direct use of the results from \code{\link{Zeta.varpart}} without editing the data.
}
\examples{
pie.neg(rep(1, 24), col = rainbow(24), radius = 0.9)
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988). \emph{The new S language}. Wadsworth & Brooks/Cole.

Cleveland, W. S. (1985). \emph{The elements of graphing data}. Wadsworth: Monterey, CA, USA.

Legendre, P. &  Legendre, L.F. (2012). \emph{Numerical ecology}, 3rd English edition. Elsevier Science BV, Amsterdam.
}
\seealso{
\code{\link[graphics]{pie}}, \code{\link{Zeta.varpart}}
}
