% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zooaRch.r
\name{surv.func}
\alias{surv.func}
\title{General survival analysis}
\usage{
surv.func(SurviveData, labels = NULL, models = NULL, ci = 95,
  plot = TRUE, iter = 1000, usermod = NULL)
}
\arguments{
\item{SurviveData}{This function inputs datasets composed of three columns. 
The first column denotes the genus; the second is the age class (this MUST be numeric) 
if data contains nominal age classes (e.g., 'A', 'B', 'C', etc.) these data must be converted
to numbers (e.g., A = 1, B = 2, etc.).}

\item{labels}{Character value indicating wether age class labels wishing to be displayed.}

\item{models}{A numerical value (1-5) indiacting the models to compare the data to. Currently surv.func
makes use of 5 survival models: 1) Security (ref); 2) Milk (ref); 3) Wool (ref); 
4) Catastrophic (Stiner 1990); and 5) Attritional (Stiner 1990). More models will be added soon. 
An option to include user's own model will also be available.}

\item{ci}{Numerical value indicating desired CI level (e.g., 90, 95, 99). Defaults to 95.}

\item{plot}{A logical value indicating wether user wishes an output plot. Default = TRUE.}

\item{iter}{A numeric value indicating the number of bootstrap iterations. Defaults to 1000.}

\item{usermod}{numeric list (see help(list)) user-specified survivorship model. See example 3 below. 
Data must be entered as a list, else user will receive error.}
}
\value{
Function returns a matrix with the following components 
  \item{Lower and Upper CI}{typically the 97.5 and 2.5 percentile markers}
  \item{Point Value}{the y value on the survivorship curve}
}
\description{
A general function to perform survival analysis of zooarchaeological data
}
\details{
The function constructs Kaplan-Meier Estimator (KME) Confidence Intervals
Using Dental Eruption Wear Data
}
\examples{
# Example 1: Payne 1973
 data(marjRab)

# Inspect data structure  
 head(marjRab)
 
# create age-class labels: Payne 1973 uses ageclasses A-I
 Labels <-c('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I')
 surv.func(SurviveData=marjRab,labels=Labels, models=1:3, ci=95, plot=TRUE, iter=1000)
 
# Example 2: Garnsey Site Bison Data (from Speth 1983)
 data(speth83)

# Inspect data structure  
 head(speth83)

# create age-class labels using the 13 age classes of Speth's (1983) scheme.
 Labels <-c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)

# Use the catastrophic and attritional mortality curves (after Stiner 1990).
 surv.func(SurviveData=speth83,labels=Labels, models=4:5, ci=95, plot=TRUE, iter=1000)
 
# Example 3: marjRab, input user-defined survivorship models.
data(marjRab)
# extract age classes from marjRab
age<-unique(marjRab$Ageclass)
age
# model survivorship using an exponential decay function 
# with parameter b: survivorship = age^(-1/b)
# surv 1: b= .95 
surv1<-c(1.00, 0.48, 0.31, 0.23, 0.18, 0.15, 0.12, 0.11, 0.09)
# surv 2: b= .35
surv2<-c(1.00, 0.13, 0.04, 0.01, 0.01, 0.005, 0.003, 0.002, 0.001)

plot(age, surv1,type='l',xlim=range(age),ylim=c(0,1))
lines(age, surv2,col='red',)

# usermods in surv.func must be a list (if not a list, then user will receive error message)
mods<-list(surv1=surv1,surv2=surv2)

surv.func(marjRab,models=NULL,usermod=mods)
}
\author{
Jesse WolfHagen and Erik Otarola-Castillo.
}
\references{
Klein, R.G., Cruz-Uribe, K., 1983. The Analysis of Animal Bones from Archaeological Sites, University of Chicago Press, Chicago.

Stiner, M. C. 1990	The Use of Mortality Patterns in Archaeological Studies 
of Homonid Predatory Adaptations. Journal of Anthropological Archaeology 9:305 - 351.

Lyman, R.L., 1994. Vertebrate Taphonomy, Cambridge University Press, Cambridge.

Zeder, M.A., 2006. Reconciling Rates of Long Bone Fusion and Tooth Eruption in Sheep (Ovis) and Goat (Capra), in: Ruscillo, D. (Ed.), Recent Advances in Ageing and Sexing Animal Bones, Oxbow Books, Oxford.

Twiss, K.C., 2008. An Assessment of the Archaeological Applicability of Faunal Ageing Methods Based on Dental Wear, International Journal of Osteoarchaeology 18, 329-351.
}
\keyword{analysis}

