% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_col.R
\name{filter_col}
\alias{filter_col}
\alias{filter_col.zoocat}
\alias{filter_col.zoomly}
\alias{filter_col_q}
\alias{filter_col_q.zoocat}
\alias{filter_col_q.zoomly}
\title{Return columns with matching conditions}
\usage{
filter_col_q(x, ...)

filter_col(x, ...)

\method{filter_col_q}{zoocat}(x, cond, ...)

\method{filter_col}{zoocat}(x, cond, ...)

\method{filter_col_q}{zoomly}(x, cond = NULL, mon.repro = NULL, ...)

\method{filter_col}{zoomly}(x, cond = NULL, mon.repro = NULL, ...)
}
\arguments{
\item{x}{the object.}

\item{...}{other arguments.}

\item{cond}{logical predicates of conditions. Multiple conditions are 
combined with \code{&}. 
For \code{filter_col}, \code{cond} must be an expression, 
while for \code{filter_col_q}, \code{cond} must be a quoted expression.}

\item{mon.repro}{the reprocessing month vector, which is used for \code{\link{reprocess_month}}. 
See details.}
}
\value{
a "\code{zoocat}" or "\code{zoomly}" object.
}
\description{
Return columns with matching conditions for the column attributes (\bold{cattr}) table.
}
\details{
For \code{filter_col}, when the argument \code{mon.repro} is not \code{NULL}, \code{reprocess_month}
will be called in the last step.
}
\examples{
x <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = c(rep('xxx', 3), 'yyy'))
zc <- zoocat(x, order.by = 1991 : 1995, colattr = colAttr)
filter_col(zc, month > 2)
filter_col(zc, month > 2)
filter_col(zc, month > 2 & name == 'yyy')

mat <- matrix(1:48, ncol = 12)
colAttr <- data.frame(month = rep(1 : 12))
zm <- zoomly(mat, order.by = 1991 : 1994, colattr = colAttr)
filter_col(zm, mon.repro = 1 : 3)
filter_col(zm, mon.repro = c(-9 : 8))
filter_col(zm, cond = month \%in\% 1 : 3, mon.repro = c(-24 : 3))

}

