% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{prcomp.zoocat}
\alias{prcomp.zoocat}
\title{Principal components analysis of a \code{zoocat} object}
\usage{
\method{prcomp}{zoocat}(x, ...)
}
\arguments{
\item{x}{the zoocat object.}

\item{...}{other argument.}
}
\value{
a list with following elements: \code{prcomp.obj} (the object returned by \code{stats::prcomp}),
\code{rotation} (the data frame containing information of the variable loadings),
\code{z} (the \code{zoo} object containing the rotated data).
}
\description{
Principal components analysis of a "\code{zoocat}" object. This function is a 
wrap of the \code{stats::prcomp}. The \code{rotation} returned by \code{stats::prcomp}
is binded with the \code{cattr} table to be a data frame, and the \code{x} returned 
by \code{stats::prcomp} is binded with the \code{index} to be a "\code{zoo}" object.
}
\examples{
x <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = c(rep('xxx', 3), 'yyy'))
zc <- zoocat(x, order.by = 1991 : 1995, colattr = colAttr)
pca <- prcomp(zc)
print(pca$rotation)
print(pca$z)

}

