% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollcor.R
\name{rollcor}
\alias{rollcor}
\alias{rollcor.default}
\alias{rollcor.zoo}
\title{Calculate the rolling window correlations}
\usage{
rollcor(x, y, ...)

\method{rollcor}{default}(x, y, width, show = TRUE, ...)

\method{rollcor}{zoo}(x, y, width, show = TRUE, ...)
}
\arguments{
\item{x, y}{Two vectors or two zoo objects. For zoo objects, if their time
ranges is different, intersection will be used.}

\item{...}{Other arguments for function cor.}

\item{width}{The width of the sliding window, which must be odd number.}

\item{show}{If TRUE, the result will be plotted.}
}
\value{
\code{rollcor.default} return a vector, and \code{rollcor.zoo}
return a "\code{zoo}" object.
}
\description{
Calculate the rolling window correlations.
}
\examples{

x <- 1 : 100
y <- 2 * x + rnorm(100, 0, 10)
rollcor(x, y, width = 21)

xz <- zoo(x)
yz <- zoo(y)
rollcor(xz, yz, width = 21)

rollcor(xz, yz, width = 21, show = FALSE)

x <- 1 : 100
y <- 2 * x  + rnorm(100, 0, 10)
x <- zoo(x, order.by = 10 : 109)
y <- zoo(y, order.by = -3 : 96)
rollcor(x, y, width = 21, method = 'kendall')

}

