use super::{color::Color, FontFace, LineType};










const POINTSIZE: f64 = 12.0;

const PT: f64 = 1.0 / 72.0;
const PT_PER_INCH: f64 = 72.0;









const FONTSIZE: f64 = POINTSIZE;






const WIDTH_INCH: f64 = 7.0;
const HEIGH_INCH: f64 = 7.0;

#[allow(dead_code)]
pub(crate) enum CanHAdjOption {
    NotSupported = 0,
    FixedAdjustment = 1,
    VariableAdjustment = 2,
}

pub enum DevCapTransparency {
    Unset = 0,
    No = 1,
    Yes = 2,
}

pub enum DevCapTransparentBg {
    Unset = 0,
    No = 1,
    Fully = 2,
    Semi = 3,
}

#[allow(dead_code)]
pub(crate) enum DevCapRaster {
    Unset = 0,
    No = 1,
    Yes = 2,
    ExceptForMissingValues = 3,
}

#[allow(dead_code)]
pub(crate) enum DevCapCapture {
    Unset = 0,
    No = 1,
    Yes = 2,
}

#[allow(dead_code)]
pub(crate) enum DevCapLocator {
    Unset = 0,
    No = 1,
    Yes = 2,
}






























#[allow(non_snake_case)]
pub struct DeviceDescriptor {
    pub(crate) left: f64,
    pub(crate) right: f64,
    pub(crate) bottom: f64,
    pub(crate) top: f64,









    pub(crate) ipr: [f64; 2],
    pub(crate) cra: [f64; 2],

    pub(crate) startps: f64,
    pub(crate) startcol: Color,
    pub(crate) startfill: Color,
    pub(crate) startlty: LineType,
    pub(crate) startfont: FontFace,
}

#[allow(non_snake_case)]
impl DeviceDescriptor {
    pub fn new() -> Self {
        Self {


            left: 0.0,
            right: WIDTH_INCH * PT_PER_INCH,
            bottom: 0.0,
            top: HEIGH_INCH * PT_PER_INCH,

            ipr: [PT, PT],



            cra: [0.9 * FONTSIZE, 1.2 * FONTSIZE],

            startps: POINTSIZE,
            startcol: Color::hex(0x000000),
            startfill: Color::hex(0xffffff),
            startlty: LineType::Solid,
            startfont: FontFace::Plain,
        }
    }

















    pub fn device_size(mut self, left: f64, right: f64, bottom: f64, top: f64) -> Self {
        self.left = left;
        self.right = right;
        self.bottom = bottom;
        self.top = top;
        self
    }







    pub fn ipr(mut self, ipr: [f64; 2]) -> Self {
        self.ipr = ipr;
        self
    }











    pub fn cra(mut self, cra: [f64; 2]) -> Self {
        self.cra = cra;
        self
    }





    pub fn startps(mut self, startps: f64) -> Self {
        self.startps = startps;
        self
    }




    pub fn startcol(mut self, startcol: Color) -> Self {
        self.startcol = startcol;
        self
    }



    pub fn startfill(mut self, startfill: Color) -> Self {
        self.startfill = startfill;
        self
    }




    pub fn startlty(mut self, startlty: LineType) -> Self {
        self.startlty = startlty;
        self
    }




    pub fn startfont(mut self, startfont: FontFace) -> Self {
        self.startfont = startfont;
        self
    }
}

impl Default for DeviceDescriptor {
    fn default() -> Self {
        Self::new()
    }
}
